#!/bin/bash

CONF=${CONF:-'/etc/netzmon/netzmon.conf'}
TRIGGERDIR=${TRIGGERDIR:='/local/adm/netzmon/var/triggers'}

[[ -e ${CONF} ]] && . ${CONF}

PRG="triggers"
PRGVER="001"

# test if data has to be generated locally
if [[ -z ${DATASRC} ]]; then

	# local generation of values
	for ((i=0;i<16;i++)); do
		if [ -e "${TRIGGERDIR}/${i}" ]; then
			trigger[${i}]=`cat "${TRIGGERDIR}/${i}"`
			echo -n "0" > "${TRIGGERDIR}/${i}"
		else
			trigger[${i}]=0
		fi
	done

	# local history
    echo "${DATUM} ${TODAY}:${trigger[0]}:${trigger[1]}:${trigger[2]}:${trigger[3]}:${trigger[4]}:${trigger[5]}:${trigger[6]}:${trigger[7]}:${trigger[8]}:${trigger[9]}:${trigger[10]}:${trigger[11]}:${trigger[12]}:${trigger[13]}:${trigger[14]}:${trigger[15]}" >> $DATADIR/${PRG}-history.${UDATE}

fi

if [[ ${OUTTYPE} == "txt" ]]; then

	echo "${PRG}:${PRGVER} ${TODAY}:${trigger[0]}:${trigger[1]}:${trigger[2]}:${trigger[3]}:${trigger[4]}:${trigger[5]}:${trigger[6]}:${trigger[7]}:${trigger[8]}:${trigger[9]}:${trigger[10]}:${trigger[11]}:${trigger[12]}:${trigger[13]}:${trigger[14]}:${trigger[15]}" >> ${OUTDIR}/report.txt

elif [[ ${OUTTYPE} == "rrd" ]]; then

	[ -e ${RRDDIR}/${PRG}.rrd ] || ${BINDIR}/mkrrd.sh ${PRG}

	if [[ -n ${DATASRC} ]]; then
		grep "^${PRG}:${PRGVER} " ${DATASRC} | awk '{ print $2 }'| \
			while read record; do
				[[ -n ${record} ]] && ${RRDTOOL} update ${RRDDIR}/${PRG}.rrd  ${record}
			done
	else

		$RRDTOOL update $RRDDIR/${PRG}.rrd ${TODAY}:${trigger[0]}:${trigger[1]}:${trigger[2]}:${trigger[3]}:${trigger[4]}:${trigger[5]}:${trigger[6]}:${trigger[7]}:${trigger[8]}:${trigger[9]}:${trigger[10]}:${trigger[11]}:${trigger[12]}:${trigger[13]}:${trigger[14]}:${trigger[15]}

	fi

fi

