#!/bin/bash
# Werte fuer SWAP-Auslastung ermitteln und speichern

CONF=${CONF:-'/etc/netzmon/netzmon.conf'}

[[ -e ${CONF} ]] && . ${CONF}

PRG="swap"
PRGVER="002"

# test if data has to be generated locally
if [[ -z ${DATASRC} ]]; then

	# mem-Werte aus /proc/meminfo holen
	SWAPFREE=`grep SwapFree /proc/meminfo | awk '{ print $2 }'`
	SWAPTOTAL=`grep SwapTotal /proc/meminfo | awk '{ print $2 }'`

	echo "${DATUM} ${TODAY}:${SWAPTOTAL}:${SWAPFREE}" >> $DATADIR/${PRG}-history.$UDATE

fi

if [[ ${OUTTYPE} == "txt" ]]; then

	echo "${PRG}:${PRGVER} ${TODAY}:${SWAPTOTAL}:${SWAPFREE}" >> ${OUTDIR}/report.txt

elif [[ ${OUTTYPE} == "rrd" ]]; then

	[ -e ${RRDDIR}/${PRG}.rrd ] || ${BINDIR}/mkrrd.sh ${PRG}

	if [[ -n ${DATASRC} ]]; then
		grep "^${PRG}:${PRGVER} " ${DATASRC} | awk '{ print $2 }'| \
			while read record; do
				[[ -n ${record} ]] && ${RRDTOOL} update ${RRDDIR}/${PRG}.rrd  ${record}
			done
	else
		${RRDTOOL} update ${RRDDIR}/${PRG}.rrd ${TODAY}:${SWAPTOTAL}:${SWAPFREE}
	fi

	# overlay triggers if needed
	TRIGGERS=$(sed 's| |\n|g' <<< ${TO} | grep "${PRG}:" |  sed "s|${PRG}:\(trigger[0-9]\{1,2\}\)|\1|g")

	if [[ ! -z ${TRIGGERS} ]]; then
		j=0
		for i in ${TRIGGERS}; do
			[ -e ${TO_REM} ] && legend=$(grep "${i}:" ${TO_REM} | sed "s|${i}: ||")
			TO_DEF="${TO_DEF} DEF:${i}=$RRDDIR/triggers.rrd:${i}:AVERAGE"
			TO_TICK="${TO_TICK} TICK:${i}${COLOR[$((15-$j))]}:1:${legend}"
			j=$(($j+1))
		done
	fi

	$RRDTOOL graph ${OUTDIR}/${PRG}.png \
	--start -129600 \
	--vertical-label "Mbytes" \
	--title "swap usage $DATUM" \
	--imgformat PNG \
	--width $WIDTH \
	--height $HEIGHT \
	--font TITLE:12:${FONTSDIR}/micrb.ttf \
	--font UNIT:10:${FONTSDIR}/micr.ttf \
	--font LEGEND:8:${FONTSDIR}/DejaVuSansMono-Roman.ttf \
	--font-render-mode normal \
	--font-smoothing-threshold 4 \
	--slope-mode \
	--interlaced \
	$RRDOPTS \
	-b 1024 \
	-l 3 \
	"DEF:total_o=$RRDDIR/${PRG}.rrd:swaptotal:AVERAGE" \
	"DEF:free_o=$RRDDIR/${PRG}.rrd:swapfree:AVERAGE" \
	"CDEF:total=total_o,1024,/" \
	"CDEF:free=free_o,1024,/" \
	"CDEF:used=total,free,-" \
	'COMMENT:           minimum      maximum     average        last\n'\
	'AREA:used#e9644a:used    ' \
	'LINE1:used#ba361a:' \
	'GPRINT:used:MIN:%5.0lfM    ' \
	'GPRINT:used:MAX:%5.0lfM    ' \
	'GPRINT:used:AVERAGE:%5.0lfM    ' \
	'GPRINT:used:LAST:%5.0lfM' \
	'COMMENT:\n'\
	'AREA:free#e5e5e5:free    :STACK' \
	'LINE1:total#999999:' \
	'GPRINT:free:MIN:%5.0lfM    ' \
	'GPRINT:free:MAX:%5.0lfM    ' \
	'GPRINT:free:AVERAGE:%5.0lfM    ' \
	'GPRINT:free:LAST:%5.0lfM' \
	${TO_DEF} \
	${TO_TICK}

	$RRDTOOL graph ${OUTDIR}/${PRG}-mini.png \
	--start -86400 \
	--vertical-label "Mbytes" \
	--title "swap $DATUM" \
	--imgformat PNG \
	--width $MWIDTH \
	--height $MHEIGHT \
	--no-legend \
	--font TITLE:10:${FONTSDIR}/DejaVuSansMono-Roman.ttf \
	--font UNIT:8:${FONTSDIR}/DejaVuSansMono-Roman.ttf \
	--font-render-mode normal \
	--font-smoothing-threshold 6 \
	--slope-mode \
	--interlaced \
	$RRDOPTS \
	-b 1024 \
	-l 6 \
	"DEF:total_o=$RRDDIR/${PRG}.rrd:swaptotal:AVERAGE" \
	"DEF:free_o=$RRDDIR/${PRG}.rrd:swapfree:AVERAGE" \
	"CDEF:total=total_o,1024,/" \
	"CDEF:free=free_o,1024,/" \
	"CDEF:used=total,free,-" \
	'AREA:used#e9644a:t' \
	'LINE1:used#ba361a:' \
	'AREA:free#e5e5e5::STACK' \
	'LINE1:total#999999:' \
	${TO_DEF} \
	${TO_TICK}

fi

