#!/bin/bash
# Werte fuer Prozessanzahl Gesamt/HTTPD ermitteln und speichern

CONF=${CONF:-'/etc/netzmon/netzmon.conf'}

[[ -e ${CONF} ]] && . ${CONF}

PRG="processes"
PRGVER="002"

# test if data has to be generated locally
if [[ -z ${DATASRC} ]]; then

	TOTALPRCS=$(ps -eL | wc -l)
	HISTORY="${DATUM} ${TODAY}:${TOTALPRCS}"
	TXTREPORT="${PRG}:${PRGVER}:${PRCS// /:} ${TODAY}:${TOTALPRCS}"
	RRDCMD_UPDATE="${RRDTOOL} update ${RRDDIR}/${PRG}.rrd ${TODAY}:${TOTALPRCS}"
else

	# find out what PRCS we have to generate
	REMOTEPRCS=`grep "^${PRG}:" ${DATASRC} | awk '{ print $1 }' | tail -n1 | sed "s|^${PRG}:${PRGVER}:||g"`
	PRCS="${REMOTEPRCS//:/ }"

fi

count=1
STACK=""
RRDCMD_LARGE="DEF:proc0=$RRDDIR/${PRG}.rrd:proc0:AVERAGE \
	AREA:proc0${COLOR[0]}:\"total  \t\" \
	GPRINT:proc0:MIN:\"%5.0lf    \" \
	GPRINT:proc0:MAX:\"%5.0lf    \" \
	GPRINT:proc0:AVERAGE:\"%5.0lf    \" \
	GPRINT:proc0:LAST:\"%5.0lf\" \
	'COMMENT:\n' "
RRDCMD_SMALL="DEF:proc0=$RRDDIR/${PRG}.rrd:proc0:AVERAGE \
	AREA:proc0${COLOR[0]}: \
	'COMMENT:\n' "

for process in ${PRCS}; do

	[[ ${count} > 1 ]] && STACK="STACK"

	# test if data has to be generated locally
	if [[ -z ${DATASRC} ]]; then
		processno=$(ps -eL | grep ${process} | wc -l)
		HISTORY="$HISTORY:${processno}"
		TXTREPORT="${TXTREPORT}:${processno}"
		RRDCMD_UPDATE="${RRDCMD_UPDATE}:${processno}"
	fi

	RRDCMD_LARGE="${RRDCMD_LARGE} \
		DEF:proc${count}=$RRDDIR/${PRG}.rrd:proc${count}:AVERAGE \
		AREA:proc${count}${COLOR[$(($count))]}:\"${process}  \t\":${STACK} \
		GPRINT:proc${count}:MIN:\"%5.0lf    \"\
		GPRINT:proc${count}:MAX:\"%5.0lf    \" \
		GPRINT:proc${count}:AVERAGE:\"%5.0lf    \" \
		GPRINT:proc${count}:LAST:\"%5.0lf\" \
		'COMMENT:\n' "

	RRDCMD_SMALL="${RRDCMD_SMALL} \
		DEF:proc${count}=$RRDDIR/${PRG}.rrd:proc${count}:AVERAGE \
		AREA:proc${count}${COLOR[$(($count))]}::${STACK} \
		'COMMENT:\n' "

	count=$((${count}+1))

done

if [[ -z ${DATASRC} ]]; then

	# rrdtool expects 16 values
	for ((i=${count};i<16;i++)); do
		TXTREPORT="${TXTREPORT}:0"
		RRDCMD_UPDATE="${RRDCMD_UPDATE}:0"
		HISTORY="${HISTORY}:0"
	done

	# Werte archivieren
	echo ${HISTORY} >> ${DATADIR}/${PRG}-history.${UDATE}

fi

if [[ ${OUTTYPE} == "txt" ]]; then

	echo "${TXTREPORT}" >> ${OUTDIR}/report.txt

elif [[ ${OUTTYPE} == "rrd" ]]; then

	[ -e ${RRDDIR}/${PRG}.rrd ] || ${BINDIR}/mkrrd.sh ${PRG}

	if [[ -n ${DATASRC} ]]; then
		grep "^${PRG}:" ${DATASRC} | awk '{ print $2 }'| \
			while read record; do
				[[ -n ${record} ]] && ${RRDTOOL} update ${RRDDIR}/${PRG}.rrd  ${record}
			done
	else
		eval ${RRDCMD_UPDATE}
	fi

	# overlay triggers if needed
	TRIGGERS=$(sed 's| |\n|g' <<< ${TO} | grep "${PRG}:" |  sed "s|${PRG}:\(trigger[0-9]\{1,2\}\)|\1|g")

	if [[ ! -z ${TRIGGERS} ]]; then
		j=0
		for i in ${TRIGGERS}; do
			[ -e ${TO_REM} ] && legend=$(grep "${i}:" ${TO_REM} | sed "s|${i}: ||")
			TO_DEF="${TO_DEF} DEF:${i}=$RRDDIR/triggers.rrd:${i}:AVERAGE"
			TO_TICK="${TO_TICK} TICK:${i}${COLOR[$((15-$j))]}:1:${legend}"
			j=$(($j+1))
		done
	fi

	RRDCMD="$RRDTOOL graph ${OUTDIR}/${PRG}.png \
	--start -129600 \
	--vertical-label 'processes' \
	--title='process count  $DATUM' \
	--imgformat PNG \
	--lower-limit 0 \
	--width $WIDTH \
	--height $HEIGHT \
	--font TITLE:12:${FONTSDIR}/micrb.ttf \
	--font UNIT:10:${FONTSDIR}/micr.ttf \
	--font LEGEND:8:${FONTSDIR}/DejaVuSansMono-Roman.ttf \
	--font-render-mode normal \
	--font-smoothing-threshold 4 \
	--slope-mode \
	--interlaced \
	$RRDOPTS \
	'COMMENT:process name  minimum    maximum    average      last\n' \
	${RRDCMD_LARGE} \
	${TO_DEF} \
	${TO_TICK}
	"

	eval "${RRDCMD}"

	RRDCMD="$RRDTOOL graph ${OUTDIR}/${PRG}-mini.png \
	--start -86400 \
	--vertical-label 'processes' \
	--title='processes $DATUM' \
	--imgformat PNG \
	--lower-limit 0 \
	--width $MWIDTH \
	--height $MHEIGHT \
	--no-legend \
	--font TITLE:10:${FONTSDIR}/DejaVuSansMono-Roman.ttf \
	--font UNIT:8:${FONTSDIR}/DejaVuSansMono-Roman.ttf \
	--font-render-mode normal \
	--font-smoothing-threshold 6 \
	--slope-mode \
	--interlaced \
	${RRDCMD_SMALL} \
	${TO_DEF} \
	${TO_TICK}
	"

	eval "${RRDCMD}"

fi

