#!/bin/bash
# Werte fuer HTTP-Belastung per iptables ermitteln und speichern

CONF=${CONF:-'/etc/netzmon/netzmon.conf'}

[[ -e ${CONF} ]] && . ${CONF}

PRG="netweb-ipt"
PRGVER="001"

# test if data has to be generated locally
if [[ -z ${DATASRC} ]]; then

	HTTP="$($IPTABLES -vnxL web -Z | grep 'RETURN' | awk '{ print $2 }')"

	# Werte fuer zukuenftige Auswertungen speichern
	echo $DATUM $TODAY:$HTTP >> $DATADIR/${PRG}-history.$UDATE

fi

if [[ ${OUTTYPE} == "txt" ]]; then

	echo "${PRG}:${PRGVER} $TODAY:$HTTP" >> ${OUTDIR}/report.txt

elif [[ ${OUTTYPE} == "rrd" ]]; then

	[ -e ${RRDDIR}/${PRG}.rrd ] || ${BINDIR}/mkrrd.sh ${PRG}

	if [[ -n ${DATASRC} ]]; then
		grep "^${PRG}:" ${DATASRC} | awk '{ print $2 }'| \
			while read record; do
				[[ -n ${record} ]] && ${RRDTOOL} update ${RRDDIR}/${PRG}.rrd  ${record}
			done
	else
		${RRDTOOL} update ${RRDDIR}/${PRG}.rrd ${TODAY}:${HTTP}
	fi

	# overlay triggers if needed
	TRIGGERS=$(sed 's| |\n|g' <<< ${TO} | grep "${PRG}:" |  sed "s|${PRG}:\(trigger[0-9]\{1,2\}\)|\1|g")

	if [[ ! -z ${TRIGGERS} ]]; then
		j=0
		for i in ${TRIGGERS}; do
			[ -e ${TO_REM} ] && legend=$(grep "${i}:" ${TO_REM} | sed "s|${i}: ||")
			TO_DEF="${TO_DEF} DEF:${i}=$RRDDIR/triggers.rrd:${i}:AVERAGE"
			TO_TICK="${TO_TICK} TICK:${i}${COLOR[$((15-$j))]}:1:${legend}"
			j=$(($j+1))
		done
	fi

	${RRDTOOL} graph ${OUTDIR}/${PRG}.png \
	--start -129600 \
	--vertical-label "bytes per second" \
	--title="httpd traffic $DATUM" \
	--imgformat PNG \
	--base 1000 \
	--width $WIDTH \
	--height $HEIGHT \
	--font TITLE:12:${FONTSDIR}/micrb.ttf \
	--font UNIT:10:${FONTSDIR}/micr.ttf \
	--font LEGEND:8:${FONTSDIR}/DejaVuSansMono-Roman.ttf \
	--font-render-mode normal \
	--font-smoothing-threshold 4 \
	--slope-mode \
	--interlaced \
	$RRDOPTS \
	DEF:http_o=$RRDDIR/${PRG}.rrd:http:AVERAGE \
	CDEF:http=http_o,1024,/ \
	'COMMENT:             minimum     maximum     average        last\n' \
	AREA:http_o#32cd32:"httpd    "  \
	'GPRINT:http:MIN:%5.0lfk    ' \
	'GPRINT:http:MAX:%5.0lfk    ' \
	'GPRINT:http:AVERAGE:%5.0lfk    ' \
	'GPRINT:http:LAST:%5.0lfk' \
	'COMMENT:\n' \
	${TO_DEF} \
	${TO_TICK}

	$RRDTOOL graph ${OUTDIR}/${PRG}-mini.png \
	--start -86400 \
	--vertical-label "bytes per second" \
	--title="httpd  $DATUM" \
	--imgformat PNG \
	--base 1000 \
	--width $MWIDTH \
	--height $MHEIGHT \
	--no-legend \
	--font TITLE:10:${FONTSDIR}/DejaVuSansMono-Roman.ttf \
	--font UNIT:8:${FONTSDIR}/DejaVuSansMono-Roman.ttf \
	--font-render-mode normal \
	--font-smoothing-threshold 6 \
	--slope-mode \
	--interlaced \
	$RRDOPTS \
	DEF:http=$RRDDIR/${PRG}.rrd:http:AVERAGE \
	AREA:http#32cd32:""\
	${TO_DEF} \
	${TO_TICK}

fi

