#!/bin/bash
#
# netacct-tc.sh - generate detailed traffic stats based on tc counters

CONF=${CONF:-'/etc/netzmon/netzmon.conf'}

[[ -e ${CONF} ]] && . ${CONF}

PRG="netacct-tc"
PRGVER="001"

strtobyte()
{
	str=$1
	unset transform
	numeric=$( sed 's|\([0-9]*\).*|\1|' <<< ${str} )
	grep -q 'bit' <<< ${str} && transform="${transform}/8"
	grep -i -q 'k' <<< ${str} && transform="${transform}*1024"
	grep -i -q 'm' <<< ${str} && transform="${transform}*1024*1024"
	grep -i -q 'g' <<< ${str} && transform="${transform}*1024*1024*1024"
	echo ${numeric}${transform} | bc
}



for DEVICE in ${ACCT_TC}; do

	unset RRDCMD_LARGE
	unset RRDCMD_SMALL

	# test if data has to be generated locally
	if [[ -z ${DATASRC} ]]; then

		CLASSES_ALL=$( ${TC} -s filter show dev ${DEVICE} | grep 'classid' | sed 's|.*classid \(.*\).*|\1|;s|:|.|' | tac | xargs )
		PARENTS=$( ${TC}  -s class show dev ${DEVICE} | grep 'parent.*leaf' | sed 's|.*parent \(.*\)* leaf.*|\1|g' | sort -u | xargs )

		for parent in $PARENTS; do
			CLASSES_ALL=`echo ${CLASSES_ALL//./_} | sed "s|${parent//:/_} ||"`
		done

		CLASSES_ALL=${CLASSES_ALL//_/.}

		HISTORY="${DATUM} ${TODAY}"
		TXTREPORT="${PRG}:${PRGVER}:${DEVICE}:${CLASSES_ALL// /:} ${TODAY}"
		RRDCMD_UPDATE="${RRDTOOL} update ${RRDDIR}/${PRG}-${DEVICE}.rrd ${TODAY}"

	else

		REMOTECLASSES=`grep "^${PRG}:${PRGVER}:${DEVICE}:" ${DATASRC} | awk '{ print $1 }' | tail -n1 | sed "s|^${PRG}:${PRGVER}:${DEVICE}:||g"`
		CLASSES_ALL="${REMOTECLASSES//:/ }"

	fi

	count=1

	for CLASS in ${CLASSES_ALL}; do

		# test if data has to be generated locally
		if [[ -z ${DATASRC} ]]; then

			bytes=$( ${TC} -s class show dev ${DEVICE} | grep -A1 "${CLASS//./:} parent" | grep Sent | sed 's|Sent \(.*\) bytes.*|\1|' | sed 's|[ \t]||g' )
			rate=$( ${TC} -s class show dev ${DEVICE} | grep "${CLASS//./:} parent" | sed 's|.*rate \(.*\) ceil.*|\1|' )
			ceil=$( ${TC} -s class show dev ${DEVICE} | grep "${CLASS//./:} parent" | sed 's|.*ceil \(.*\) burst.*|\1|' )

			rate=$( strtobyte ${rate} )
			ceil=$( strtobyte ${ceil} )

			HISTORY="$HISTORY:${bytes}:${rate}:${ceil}"
			TXTREPORT="${TXTREPORT}:${bytes}:${rate}:${ceil}"
			RRDCMD_UPDATE="${RRDCMD_UPDATE}:${bytes}:${rate}:${ceil}"
		fi

		unset REMARK
		[[ -n ${ACCT_TC_REM} && -e ${ACCT_TC_REM} ]] && \
			REMARK=$( grep "${CLASS//./:}=" ${ACCT_TC_REM} | awk ' BEGIN { FS="=" } { print $2 }' )

		RRDCMD_LARGE="${RRDCMD_LARGE} \
			DEF:bytes${count}=$RRDDIR/${PRG}-${DEVICE}.rrd:bytes${count}:AVERAGE \
			DEF:rate${count}=$RRDDIR/${PRG}-${DEVICE}.rrd:rate${count}:AVERAGE \
			DEF:ceil${count}=$RRDDIR/${PRG}-${DEVICE}.rrd:ceil${count}:AVERAGE \
			CDEF:kbytes${count}=bytes${count},1024,/ \
			CDEF:krate${count}=rate${count},1024,/ \
			CDEF:kceil${count}=ceil${count},1024,/ \
			AREA:bytes${count}${COLOR[$(($count-1))]}:\"${CLASS}\t\":STACK \
			GPRINT:kceil${count}:LAST:\"%5.0lfk  \" \
			GPRINT:krate${count}:LAST:\"%5.0lfk  \" \
			GPRINT:kbytes${count}:MAX:\"%5.0lfk  \" \
			GPRINT:kbytes${count}:AVERAGE:\"%5.0lfk  \" \
			GPRINT:kbytes${count}:LAST:\"%5.0lfk   ${REMARK}\" \
			'COMMENT:\n' "
		RRDCMD_SMALL="${RRDCMD_SMALL} \
			DEF:byte${count}=$RRDDIR/${PRG}-${DEVICE}.rrd:bytes${count}:AVERAGE \
			AREA:byte${count}${COLOR[$(($count-1))]}::STACK \
			'COMMENT:\n'"
		count=$((${count}+1))
	done

	if [[ -z ${DATASRC} ]]; then
			# rrdtool expects 16 values
		for ((i=$count;i<17;i++)); do
			TXTREPORT="${TXTREPORT}:0:0:0"
			RRDCMD_UPDATE="${RRDCMD_UPDATE}:0:0:0"
			HISTORY="${HISTORY}:0:0:0"
		done

		# Werte archivieren
		echo ${HISTORY} >> ${DATADIR}/${PRG}-history.${UDATE}
	fi

	if [[ ${OUTTYPE} == "txt" ]]; then

		echo "${TXTREPORT}" >> ${OUTDIR}/report.txt

	elif [[ ${OUTTYPE} == "rrd" ]]; then

		[ -e ${RRDDIR}/${PRG}.rrd ] || ${BINDIR}/mkrrd.sh ${PRG}

		if [[ -n ${DATASRC} ]]; then
			grep "^${PRG}:${PRGVER}:${DEVICE}:" ${DATASRC} | awk '{ print $2 }'| \
				while read record; do
					[[ -n ${record} ]] && ${RRDTOOL} update ${RRDDIR}/${PRG}-${DEVICE}.rrd  ${record}
				done
		else
			# Werte in RRD speichern
			eval ${RRDCMD_UPDATE}
		fi

		# overlay triggers if needed
		TRIGGERS=$(sed 's| |\n|g' <<< ${TO} | grep "${PRG}:" |  sed "s|${PRG}:\(trigger[0-9]\{1,2\}\)|\1|g")

		if [[ ! -z ${TRIGGERS} ]]; then
			j=0
			for i in ${TRIGGERS}; do
				[ -e ${TO_REM} ] && legend=$(grep "${i}:" ${TO_REM} | sed "s|${i}: ||")
				TO_DEF="${TO_DEF} DEF:${i}=$RRDDIR/triggers.rrd:${i}:AVERAGE"
				TO_TICK="${TO_TICK} TICK:${i}${COLOR[$((15-$j))]}:1:${legend}"
				j=$(($j+1))
			done
		fi

		RRDCMD="$RRDTOOL graph ${OUTDIR}/${PRG}-${DEVICE}.png \
		--start -129600 \
		--vertical-label 'bytes per second' \
		--title='traffic control ${DEVICE} $DATUM' \
		--imgformat PNG \
		--width $WIDTH \
		--height $HEIGHT \
		--font TITLE:12:${FONTSDIR}/micrb.ttf \
		--font UNIT:10:${FONTSDIR}/micr.ttf \
		--font LEGEND:8:${FONTSDIR}/DejaVuSansMono-Roman.ttf \
		--font-render-mode normal \
		--font-smoothing-threshold 4 \
		--slope-mode \
		--interlaced \
		$RRDOPTS \
		'COMMENT: class        ceiling     rate    maximum    average     last    description    \n' \
		${RRDCMD_LARGE} \
		${TO_DEF} \
		${TO_TICK}
		"
		
		eval "${RRDCMD}"
	
		RRDCMD="$RRDTOOL graph ${OUTDIR}/${PRG}-${DEVICE}-mini.png \
		--start -86400 \
		--vertical-label 'bytes per second' \
		--title='tc ${DEVICE} $DATUM' \
		--imgformat PNG \
		--width $MWIDTH \
		--height $MHEIGHT \
		--no-legend \
		--font TITLE:10:${FONTSDIR}/DejaVuSansMono-Roman.ttf \
		--font UNIT:8:${FONTSDIR}/DejaVuSansMono-Roman.ttf \
		--font-render-mode normal \
		--font-smoothing-threshold 6 \
		--slope-mode \
		--interlaced \
		$RRDOPTS \
		${RRDCMD_SMALL} \
		${TO_DEF} \
		${TO_TICK}
		"
		eval "${RRDCMD}"

	fi

done


