#!/bin/bash
#
# netdetailed-ipt.sh - generate detailed traffic stats based on iptables counters

# parameters:
#  valid chain names as generated by shorewall's accounting system

CONF=${CONF:-'/etc/netzmon/netzmon.conf'}

[[ -e ${CONF} ]] && . ${CONF}

PRG="netacct-ipt"
PRGVER="001"

# test if data has to be generated locally
if [[ -z ${DATASRC} ]]; then

	if [[ -z ${ACCT} ]]; then
		echo "$0: you should setup and then specify some accounting chains"
		exit 1
	fi

	unset RRDCMD_LARGE
	unset RRDCMD_SMALL
	HISTORY="${DATUM} ${TODAY}"
	TXTREPORT="${PRG}:${PRGVER}:${ACCT// /:} ${TODAY}"
	RRDCMD_UPDATE="${RRDTOOL} update ${RRDDIR}/${PRG}.rrd ${TODAY}"

else
	# find out what ACCTs we have to generate
	REMOTEACCT=`grep "^${PRG}:" ${DATASRC} | awk '{ print $1 }' | tail -n1 | sed "s|^${PRG}:${PRGVER}:||g"`
	ACCT="${REMOTEACCT//:/ }"
fi

count=1

for port in ${ACCT}; do

	# test if data has to be generated locally
	if [[ -z ${DATASRC} ]]; then
		bytes=$(${IPTABLES} -vnxL ${port} -Z | grep 'RETURN' | awk '{ print $2 }' | xargs | sed 's| |+|g' | bc)
		HISTORY="$HISTORY:${bytes}"
		TXTREPORT="${TXTREPORT}:${bytes}"
		RRDCMD_UPDATE="${RRDCMD_UPDATE}:${bytes}"
	fi
	RRDCMD_LARGE="${RRDCMD_LARGE} \
		DEF:port${count}_o=$RRDDIR/${PRG}.rrd:port${count}:AVERAGE \
		CDEF:port${count}=port${count}_o,1024,/ \
		AREA:port${count}_o${COLOR[$(($count-1))]}:\"${port}  \t\":STACK \
		GPRINT:port${count}:MIN:\"%5.0lfk    \" \
		GPRINT:port${count}:MAX:\"%5.0lfk    \" \
		GPRINT:port${count}:AVERAGE:\"%5.0lfk    \" \
		GPRINT:port${count}:LAST:\"%5.0lfk\" \
		'COMMENT:\n' "
	RRDCMD_SMALL="${RRDCMD_SMALL} \
		DEF:port${count}=$RRDDIR/${PRG}.rrd:port${count}:AVERAGE \
		AREA:port${count}${COLOR[$(($count-1))]}::STACK \
		'COMMENT:\n'"
	count=$((${count}+1))
done

if [[ -z ${DATASRC} ]]; then

	# rrdtool expects 16 values
	for ((i=$count;i<17;i++)); do
		TXTREPORT="${TXTREPORT}:0"
		RRDCMD_UPDATE="${RRDCMD_UPDATE}:0"
		HISTORY="${HISTORY}:0"
	done

	# Werte archivieren
	echo ${HISTORY} >> ${DATADIR}/${PRG}-history.${UDATE}

fi

if [[ ${OUTTYPE} == "txt" ]]; then

	echo "${TXTREPORT}" >> ${OUTDIR}/report.txt

elif [[ ${OUTTYPE} == "rrd" ]]; then

	[ -e ${RRDDIR}/${PRG}.rrd ] || ${BINDIR}/mkrrd.sh ${PRG}

	if [[ -n ${DATASRC} ]]; then
		grep "^${PRG}:" ${DATASRC} | awk '{ print $2 }'| \
			while read record; do
				[[ -n ${record} ]] && ${RRDTOOL} update ${RRDDIR}/${PRG}.rrd  ${record}
			done
	else
		# Werte in RRD speichern
		eval ${RRDCMD_UPDATE}
	fi

	# overlay triggers if needed
	TRIGGERS=$(sed 's| |\n|g' <<< ${TO} | grep "${PRG}:" |  sed "s|${PRG}:\(trigger[0-9]\{1,2\}\)|\1|g")

	if [[ ! -z ${TRIGGERS} ]]; then
		j=0
		for i in ${TRIGGERS}; do
			[ -e ${TO_REM} ] && legend=$(grep "${i}:" ${TO_REM} | sed "s|${i}: ||")
			TO_DEF="${TO_DEF} DEF:${i}=$RRDDIR/triggers.rrd:${i}:AVERAGE"
			TO_TICK="${TO_TICK} TICK:${i}${COLOR[$((15-$j))]}:1:${legend}"
			j=$(($j+1))
		done
	fi

	RRDCMD="$RRDTOOL graph ${OUTDIR}/${PRG}.png \
	--start -129600 \
	--vertical-label 'bytes per second' \
	--title='detailed traffic $DATUM' \
	--imgformat PNG \
	--width $WIDTH \
	--height $HEIGHT \
	--font TITLE:12:${FONTSDIR}/micrb.ttf \
	--font UNIT:10:${FONTSDIR}/micr.ttf \
	--font LEGEND:8:${FONTSDIR}/DejaVuSansMono-Roman.ttf \
	--font-render-mode normal \
	--font-smoothing-threshold 4 \
	--slope-mode \
	--interlaced \
	$RRDOPTS \
	'COMMENT:               minimum    maximum     average        last\n' \
	${RRDCMD_LARGE} \
	${TO_DEF} \
	${TO_TICK}
	"
	
	eval "${RRDCMD}"
	
	RRDCMD="$RRDTOOL graph ${OUTDIR}/${PRG}-mini.png \
	--start -86400 \
	--vertical-label 'bytes per second' \
	--title='detailed  $DATUM' \
	--imgformat PNG \
	--width $MWIDTH \
	--height $MHEIGHT \
	--no-legend \
	--font TITLE:10:${FONTSDIR}/DejaVuSansMono-Roman.ttf \
	--font UNIT:8:${FONTSDIR}/DejaVuSansMono-Roman.ttf \
	--font-render-mode normal \
	--font-smoothing-threshold 6 \
	--slope-mode \
	--interlaced \
	$RRDOPTS \
	${RRDCMD_SMALL} \
	${TO_DEF} \
	${TO_TICK}
	"
	eval "${RRDCMD}"

fi

