#!/bin/bash
#
# netinfo-ipt.sh - Werte fuer Netz-Belastung (per iptables) und Fehler ermitteln und speichern

CONF=${CONF:-'/etc/netzmon/netzmon.conf'}

[[ -e ${CONF} ]] && . ${CONF}

PRG="net-ipt"
PRGVER="001"


# test if data has to be generated locally
if [[ -z ${DATASRC} ]]; then

	BYTES=0				# Bytes gesamt
	PACKETS=0			# Pakete gesamt
	RX_BYTES=0			# empfangene Bytes
	RX_PACKETS=0		# empfangene Pakete
	RX_ERRORS=0			# Fehler beim Empfang
	RX_DROPPED=0		# verlorene Pakete
	RX_OVERRUNS=0		# Pufferueberlaeufe
	TX_BYTES=0			# gesendete Bytes
	TX_PACKETS=0		# gesendete Pakete
	TX_ERRORS=0			# Fehler beim Senden
	TX_DROPPED=0		# verlorene Pakete
	TX_OVERRUNS=0		# Pufferueberlaeufe
	COLLISIONS=0		# Kollisionen

	# Gesamttraffic aus iptables-zaehlern holen (vorletzte Zeile)
	R=$(${IPTABLES} -vnxL INPUT -Z | grep -i 'accounting' | awk '{ print $1 " " $2 }')
	T=$(${IPTABLES} -vnxL OUTPUT -Z | grep -i 'accounting' | awk '{ print $1 " " $2 }')
	F=$(${IPTABLES} -vnxL FORWARD -Z | grep -i 'accounting' | awk '{ print $1 " " $2 }')
	RX_PACKETS=$(echo $R | awk '{ print $1 }')
	RX_BYTES=$(echo $R | awk '{ print $2 }')
	TX_PACKETS=$(echo $T | awk '{ print $1 }')
	TX_BYTES=$(echo $T | awk '{ print $2 }')
	FWD_PACKETS=$(echo $F | awk '{ print $1 }')
	FWD_BYTES=$(echo $F | awk '{ print $2 }')

	RX_PACKETS=$(echo "${RX_PACKETS} + ${FWD_PACKETS}" | bc)
	RX_BYTES=$(echo "${RX_BYTES} + ${FWD_BYTES}" | bc)
	TX_PACKETS=$(echo "${TX_PACKETS} + ${FWD_PACKETS}" | bc )
	TX_BYTES=$(echo "${TX_BYTES} + ${FWD_BYTES}" | bc )

	# Traffic in/out gesamt
	BYTES=$(echo "$RX_BYTES+$TX_BYTES" | bc )
	PACKETS=$(echo "$RX_PACKETS+$TX_PACKETS" | bc )

	# Fehlerzaehler aus /proc/net/dev holen und ueber alle eth* summieren
	cat /proc/net/dev | grep eth | cut -d":" -f2 | while read netpara; do
		# Netzwerkparameter in $1 bis $16 holen
		set $netpara
	
		shift
		shift
		RX_ERRORS=$(($RX_ERRORS+$1)); shift
		RX_DROPPED=$(($RX_DROPPED+$1)); shift
		RX_OVERRUNS=$(($RX_OVERRUNS+$1)); shift
		shift
		shift
		shift
		shift
		shift
		TX_ERRORS=$(($TX_ERRORS+$1)); shift
		TX_DROPPED=$(($TX_DROPPED+$1)); shift
		TX_OVERRUNS=$(($TX_OVERRUNS+$1)); shift
		COLLISIONS=$(($COLLISIONS+$1)); shift
	done
	
	# Summen Gesamtlast (empfangen + gesendet)
	ERRORS=$(($RX_ERRORS+$TX_ERRORS))
	DROPPED=$(($RX_DROPPED+$TX_DROPPED))
	OVERRUNS=$(($RX_OVERRUNS+$TX_OVERRUNS))

	echo $DATUM $TODAY:$BYTES:$PACKETS:$ERRORS:$DROPPED:$OVERRUNS:$COLLISIONS:$TX_BYTES:$TX_PACKETS:$TX_ERRORS:$TX_DROPPED:$TX_OVERRUNS:$RX_BYTES:$RX_PACKETS:$RX_ERRORS:$RX_DROPPED:$RX_OVERRUNS >> $DATADIR/${PRG}-history.$UDATE

fi

if [[ ${OUTTYPE} == "txt" ]]; then

	echo "${PRG}:${PRGVER} $TODAY:$BYTES:$PACKETS:$ERRORS:$DROPPED:$OVERRUNS:$COLLISIONS:$TX_BYTES:$TX_PACKETS:$TX_ERRORS:$TX_DROPPED:$TX_OVERRUNS:$RX_BYTES:$RX_PACKETS:$RX_ERRORS:$RX_DROPPED:$RX_OVERRUNS" >> ${OUTDIR}/report.txt

elif [[ ${OUTTYPE} == "rrd" ]]; then

	[ -e ${RRDDIR}/${PRG}.rrd ] || ${BINDIR}/mkrrd.sh ${PRG}

	if [[ -n ${DATASRC} ]]; then
		grep "^${PRG}:" ${DATASRC} | awk '{ print $2 }'| \
			while read record; do
				[[ -n ${record} ]] && ${RRDTOOL} update ${RRDDIR}/${PRG}.rrd  ${record}
			done
	else
		$RRDTOOL update $RRDDIR/${PRG}.rrd $TODAY:$BYTES:$PACKETS:$ERRORS:$DROPPED:$OVERRUNS:$COLLISIONS:$TX_BYTES:$TX_PACKETS:$TX_ERRORS:$TX_DROPPED:$TX_OVERRUNS:$RX_BYTES:$RX_PACKETS:$RX_ERRORS:$RX_DROPPED:$RX_OVERRUNS
	fi

	# overlay triggers if needed
	TRIGGERS=$(sed 's| |\n|g' <<< ${TO} | grep "${PRG}:" |  sed "s|${PRG}:\(trigger[0-9]\{1,2\}\)|\1|g")

	if [[ ! -z ${TRIGGERS} ]]; then
		j=0
		for i in ${TRIGGERS}; do
			[[ -n ${TO_REM} && -e ${TO_REM} ]] && \
				REMARK=$(grep "${i}:" ${TO_REM} | sed "s|${i}: ||")
			TO_DEF="${TO_DEF} DEF:${i}=$RRDDIR/triggers.rrd:${i}:AVERAGE"
			TO_TICK="${TO_TICK} TICK:${i}${COLOR[$((15-$j))]}:1:${REMARK}"
			j=$(($j+1))
		done
	fi

	$RRDTOOL graph ${OUTDIR}/${PRG}.png \
	--start -129600 \
	--vertical-label "bytes per second" \
	--title="total network traffic $DATUM" \
	--imgformat PNG \
	--base 1000 \
	--width $WIDTH \
	--height $HEIGHT \
	--font TITLE:12:${FONTSDIR}/micrb.ttf \
	--font UNIT:10:${FONTSDIR}/micr.ttf \
	--font LEGEND:8:${FONTSDIR}/DejaVuSansMono-Roman.ttf \
	--font-render-mode normal \
	--font-smoothing-threshold 4 \
	--slope-mode \
	--interlaced \
	$RRDOPTS \
	DEF:rx_bytes=$RRDDIR/${PRG}.rrd:rx_bytes:AVERAGE \
	DEF:tx_bytes=$RRDDIR/${PRG}.rrd:tx_bytes:AVERAGE \
	DEF:errors=$RRDDIR/${PRG}.rrd:errors:AVERAGE \
	DEF:dropped=$RRDDIR/${PRG}.rrd:dropped:AVERAGE \
	DEF:overruns=$RRDDIR/${PRG}.rrd:overruns:AVERAGE \
	DEF:collisions=$RRDDIR/${PRG}.rrd:collisions:AVERAGE \
	CDEF:rx_kbytes=rx_bytes,1024,/ \
	CDEF:tx_kbytes=tx_bytes,1024,/ \
	'COMMENT:                   minimum    maximum    average       last\n' \
	'AREA:tx_bytes#32cd32:bytes sent     ' \
	'GPRINT:tx_kbytes:MIN:%5.0lfk   ' \
	'GPRINT:tx_kbytes:MAX:%5.0lfk   ' \
	'GPRINT:tx_kbytes:AVERAGE:%5.0lfk   ' \
	'GPRINT:tx_kbytes:LAST:%5.0lfk' \
	'COMMENT:\n' \
	'AREA:rx_bytes#ffff0090:bytes received ' \
	'GPRINT:rx_kbytes:MIN:%5.0lfk   ' \
	'GPRINT:rx_kbytes:MAX:%5.0lfk   ' \
	'GPRINT:rx_kbytes:AVERAGE:%5.0lfk   ' \
	'GPRINT:rx_kbytes:LAST:%5.0lfk' \
	'COMMENT:\n' \
	'AREA:errors#FF0000:errors         ' \
	'GPRINT:errors:MIN:%5.0lf    ' \
	'GPRINT:errors:MAX:%5.0lf    ' \
	'GPRINT:errors:AVERAGE:%5.0lf' \
	'COMMENT:\n' \
	'AREA:dropped#8A2BE2:dropped        ' \
	'GPRINT:dropped:MIN:%5.0lf    ' \
	'GPRINT:dropped:MAX:%5.0lf    ' \
	'GPRINT:dropped:AVERAGE:%5.0lf' \
	'COMMENT:\n' \
	'AREA:overruns#FF8C00:overruns       ' \
	'GPRINT:overruns:MIN:%5.0lf    ' \
	'GPRINT:overruns:MAX:%5.0lf    ' \
	'GPRINT:overruns:AVERAGE:%5.0lf' \
	'COMMENT:\n' \
	'AREA:collisions#FF69B4:collisions     ' \
	'GPRINT:collisions:MIN:%5.0lf    ' \
	'GPRINT:collisions:MAX:%5.0lf    ' \
	'GPRINT:collisions:AVERAGE:%5.0lf' \
	'LINE1:rx_bytes#ffff00:' \
	'COMMENT:\n'\
	${TO_DEF} \
	${TO_TICK}

	$RRDTOOL graph ${OUTDIR}/${PRG}-mini.png \
	--start -86400 \
	--vertical-label "bytes per second" \
	--title="traffic  $DATUM" \
	--imgformat PNG \
	--base 1000 \
	--width $MWIDTH \
	--height $MHEIGHT \
	--no-legend \
	--font TITLE:10:${FONTSDIR}/DejaVuSansMono-Roman.ttf \
	--font UNIT:8:${FONTSDIR}/DejaVuSansMono-Roman.ttf \
	--font-render-mode normal \
	--font-smoothing-threshold 6 \
	--slope-mode \
	--interlaced \
	$RRDOPTS \
	DEF:rx_bytes=$RRDDIR/${PRG}.rrd:rx_bytes:AVERAGE \
	DEF:tx_bytes=$RRDDIR/${PRG}.rrd:tx_bytes:AVERAGE \
	DEF:errors=$RRDDIR/${PRG}.rrd:errors:AVERAGE \
	DEF:dropped=$RRDDIR/${PRG}.rrd:dropped:AVERAGE \
	DEF:overruns=$RRDDIR/${PRG}.rrd:overruns:AVERAGE \
	DEF:collisions=$RRDDIR/${PRG}.rrd:collisions:AVERAGE \
	'AREA:tx_bytes#32cd32:bytes sent ' \
	'AREA:rx_bytes#ffff0090:bytes received' \
	'AREA:errors#FF0000:errors         ' \
	'AREA:dropped#8A2BE2:dropped        ' \
	'AREA:overruns#FF8C00:overruns       ' \
	'AREA:collisions#FF69B4:collisions     ' \
	'LINE1:rx_bytes#ffff00:' \
	${TO_DEF} \
	${TO_TICK}

fi

