#!/bin/sh

CONF=${CONF:-'/etc/netzmon/netzmon.conf'}
[[ -e ${CONF} ]] && . ${CONF}

if [ $# = 0 ]; then
	echo "Usage: $0 [all] [statname] [statname] [statname]"
	exit 1
fi

if [ "$1" = "all" ]; then
	for i in ${ALLSTATS}; do 
		if [ -e "${BINDIR}/mkrrd_${i}.sh" ]; then
			sh ${BINDIR}/mkrrd_${i}.sh
		else
			echo "${BINDIR}/mkrrd_${i}.sh not found"
		fi
	done
fi

for i in $@; do 
	if [ -e "${BINDIR}/mkrrd_${i}.sh" ]; then
		sh ${BINDIR}/mkrrd_${i}.sh
	else
		echo "${BINDIR}/mkrrd_${i}.sh not found"
	fi
done

