#!/bin/sh

CONF=${CONF:-'/etc/netzmon/netzmon.conf'}

[[ -e ${CONF} ]] && . ${CONF}

######### large images ####################

cat <<- EOF > ${OUTDIR}/index.html
		<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
		<html>
		<head>
		<title>${HOSTNAME} stats</title>
		<meta http-equiv=refresh content='300'>
		</head>
		<body><h2>performance statistics for ${HOSTNAME} (${HOSTIP})</h2>
	EOF

for link in ${ALLSTATS}; do
	echo "<img src=\"${link}.png\" alt=\"${link}\"><br><br>" >> ${OUTDIR}/index.html
done

echo '</body></html>' >> ${OUTDIR}/index.html

######### small images ####################

cat <<- EOF > ${OUTDIR}/index-mini.html
		<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
		<html>
		<head>
		<title>${HOSTNAME} stats</title>
		<style type="text/css">
		  a {text-decoration: none;}
		  a img{ border:none;}
		</style>
		</head>
		<body><h2>performance statistics for ${HOSTNAME} (${HOSTIP})</h2>
	EOF

for link in ${ALLSTATS}; do
	echo "<a href=\"${link}.png\"><img src=\"${link}-mini.png\" alt=\"${link}\"></a><br><br>" >> ${OUTDIR}/index-mini.html
done


echo '</body></html>' >> ${OUTDIR}/index-mini.html


