#!/bin/bash
# Werte fuer Speicherauslastung ermitteln und speichern

CONF=${CONF:-'/etc/netzmon/netzmon.conf'}

[[ -e ${CONF} ]] && . ${CONF}

PRG="memory"
PRGVER="001"

# test if data has to be generated locally
if [[ -z ${DATASRC} ]]; then

	# mem-Werte aus /proc/meminfo holen
	RAMTOTAL=`grep "^MemTotal:"  /proc/meminfo | awk '{ print $2 }'`
	RAMCACHED=`grep "^Cached:"   /proc/meminfo | awk '{ print $2 }'`
	RAMBUFFERS=`grep "^Buffers:" /proc/meminfo | awk '{ print $2 }'`
	RAMFREE=`grep "^MemFree:"    /proc/meminfo | awk '{ print $2 }'`
	RAMUSED=$(( ${RAMTOTAL} - ${RAMCACHED} - ${RAMBUFFERS} - ${RAMFREE} ))

	# record values in the history file
	echo "${DATUM} ${TODAY}:${RAMTOTAL}:${RAMCACHED}:${RAMBUFFERS}:${RAMUSED}:${RAMFREE}" >> ${DATADIR}/${PRG}-history.${UDATE}

fi

if [[ ${OUTTYPE} == "txt" ]]; then

	echo "${PRG}:${PRGVER} ${TODAY}:${RAMCACHED}:${RAMBUFFERS}:${RAMUSED}:${RAMFREE}" >> ${OUTDIR}/report.txt

elif [[ ${OUTTYPE} == "rrd" ]]; then

	[ -e ${RRDDIR}/${PRG}.rrd ] || ${BINDIR}/mkrrd.sh ${PRG}

	if [[ -n ${DATASRC} ]]; then
		grep "^${PRG}:" ${DATASRC} | awk '{ print $2 }'| \
			while read record; do 
				[[ -n ${record} ]] && ${RRDTOOL} update ${RRDDIR}/${PRG}.rrd  ${record}
			done
	else
		${RRDTOOL} update ${RRDDIR}/${PRG}.rrd $TODAY:$RAMCACHED:$RAMBUFFERS:$RAMUSED:$RAMFREE
	fi

	# overlay triggers if needed
	TRIGGERS=$(sed 's| |\n|g' <<< ${TO} | grep "${PRG}:" |  sed "s|${PRG}:\(trigger[0-9]\{1,2\}\)|\1|g")

	if [[ ! -z ${TRIGGERS} ]]; then
		j=0
		for i in ${TRIGGERS}; do
			[ -e ${TO_REM} ] && legend=$(grep "${i}:" ${TO_REM} | sed "s|${i}: ||")
			TO_DEF="${TO_DEF} DEF:${i}=$RRDDIR/triggers.rrd:${i}:AVERAGE"
			TO_TICK="${TO_TICK} TICK:${i}${COLOR[$((15-$j))]}:1:${legend}"
			j=$(($j+1))
		done
	fi

	${RRDTOOL} graph ${OUTDIR}/${PRG}.png \
	--start -129600 \
	--vertical-label "Mbytes" \
	--title "average memory usage ${DATUM}" \
	--imgformat PNG \
	--width ${WIDTH} \
	--height ${HEIGHT} \
	--font TITLE:12:${FONTSDIR}/micrb.ttf \
	--font UNIT:10:${FONTSDIR}/micr.ttf \
	--font LEGEND:8:${FONTSDIR}/DejaVuSansMono-Roman.ttf \
	--font-render-mode normal \
	--font-smoothing-threshold 4 \
	--slope-mode \
	--interlaced \
	${RRDOPTS} \
	-b 1024 \
	-l 0 \
	-r \
	"DEF:cached_o=${RRDDIR}/${PRG}.rrd:ramcached:AVERAGE" \
	"DEF:buffers_o=${RRDDIR}/${PRG}.rrd:rambuffers:AVERAGE" \
	"DEF:used_o=${RRDDIR}/${PRG}.rrd:ramused:AVERAGE" \
	"DEF:free_o=${RRDDIR}/${PRG}.rrd:ramfree:AVERAGE" \
	"CDEF:used=used_o,1024,/" \
	"CDEF:cached=cached_o,1024,/" \
	"CDEF:buffers=buffers_o,1024,/" \
	"CDEF:free=free_o,1024,/" \
	"CDEF:lncached=cached,used,+" \
	"CDEF:lnbuffers=buffers,cached,used,+,+" \
	"CDEF:lnfree=free,buffers,cached,used,+,+,+" \
	'COMMENT:          minimum     maximum    average       last\n'\
	'AREA:used#e9644a:used    ' \
	'GPRINT:used:MIN:%4.0lfM    ' \
	'GPRINT:used:MAX:%4.0lfM    ' \
	'GPRINT:used:AVERAGE:%4.0lfM    ' \
	'GPRINT:used:LAST:%4.0lfM' \
	'COMMENT:\n' \
	'AREA:cached#eb9c48:cache   :STACK' \
	'GPRINT:cached:MIN:%4.0lfM    ' \
	'GPRINT:cached:MAX:%4.0lfM    ' \
	'GPRINT:cached:AVERAGE:%4.0lfM    ' \
	'GPRINT:cached:LAST:%4.0lfM' \
	'COMMENT:\n' \
	'AREA:buffers#ebd648:buffers :STACK' \
	'GPRINT:buffers:MIN:%4.0lfM    ' \
	'GPRINT:buffers:MAX:%4.0lfM    ' \
	'GPRINT:buffers:AVERAGE:%4.0lfM    ' \
	'GPRINT:buffers:LAST:%4.0lfM' \
	'COMMENT:\n' \
	'AREA:free#e5e5e5:free    :STACK' \
	'GPRINT:free:MIN:%4.0lfM    ' \
	'GPRINT:free:MAX:%4.0lfM    ' \
	'GPRINT:free:AVERAGE:%4.0lfM    ' \
	'GPRINT:free:LAST:%4.0lfM' \
	'LINE1:used#ba361a:' \
	'LINE1:lncached#bc6d18:' \
	'LINE1:lnbuffers#bdaa1b' \
	'LINE1:lnfree#999999::' \
	'COMMENT:\n' \
	${TO_DEF} \
	${TO_TICK}

#	'AREA:free#54eb48:free    :STACK' \
	${RRDTOOL} graph ${OUTDIR}/${PRG}-mini.png \
	--start -86400 \
	--vertical-label "Mbytes" \
	--title "memory ${DATUM}" \
	--imgformat PNG \
	--width ${MWIDTH} \
	--height ${MHEIGHT} \
	--no-legend \
	--font TITLE:10:${FONTSDIR}/DejaVuSansMono-Roman.ttf \
	--font UNIT:8:${FONTSDIR}/DejaVuSansMono-Roman.ttf \
	--font-render-mode normal \
	--font-smoothing-threshold 6 \
	--slope-mode \
	--interlaced \
	${RRDOPTS} \
	-b 1024 \
	-l 0 \
	-r \
	"DEF:cached_o=${RRDDIR}/${PRG}.rrd:ramcached:AVERAGE" \
	"DEF:buffers_o=${RRDDIR}/${PRG}.rrd:rambuffers:AVERAGE" \
	"DEF:used_o=${RRDDIR}/${PRG}.rrd:ramused:AVERAGE" \
	"DEF:free_o=${RRDDIR}/${PRG}.rrd:ramfree:AVERAGE" \
	"CDEF:used=used_o,1024,/" \
	"CDEF:cached=cached_o,1024,/" \
	"CDEF:buffers=buffers_o,1024,/" \
	"CDEF:free=free_o,1024,/" \
	"CDEF:lncached=cached,used,+" \
	"CDEF:lnbuffers=buffers,cached,used,+,+" \
	"CDEF:lnfree=free,buffers,cached,used,+,+,+" \
	'AREA:used#e9644a:' \
	'AREA:cached#eb9c48::STACK' \
	'AREA:buffers#ebd648::STACK' \
	'AREA:free#e5e5e5::STACK' \
	'LINE1:used#ba361a:' \
	'LINE1:lncached#bc6d18:' \
	'LINE1:lnbuffers#bdaa1b' \
	'LINE1:lnfree#999999:' \
	${TO_DEF} \
	${TO_TICK}

fi

