#!/bin/bash
# Werte fuer durchschnittlichen Load ermitteln und speichern

CONF=${CONF:-'/etc/netzmon/netzmon.conf'}

[[ -e ${CONF} ]] && . ${CONF}

PRG="loadavg"
PRGVER="001"

# test if data has to be generated locally
if [[ -z ${DATASRC} ]]; then

	# load-Werte aus /proc/meminfo holen und in integer umrechnen
	L1M=`awk '{ print $1 * 100 }' < /proc/loadavg`
	L5M=`awk '{ print $2 * 100 }' < /proc/loadavg`
	L15M=`awk '{ print $3 * 100 }' < /proc/loadavg`

	# Daten fuer zukuenftige Auswertungen speichern
	echo "${DATUM} ${TODAY}:${L1M}:${L5M}:${L15M}" >> ${DATADIR}/${PRG}-history.${UDATE}

fi

if [[ ${OUTTYPE} == "txt" ]]; then

	echo "${PRG}:${PRGVER} $TODAY:$L1M:$L5M:$L15M" >> ${OUTDIR}/report.txt

elif [[ ${OUTTYPE} == "rrd" ]]; then

	[ -e ${RRDDIR}/${PRG}.rrd ] || ${BINDIR}/mkrrd.sh ${PRG}

	if [[ -n ${DATASRC} ]]; then
		grep "^${PRG}:" ${DATASRC} | awk '{ print $2 }'| \
			while read record; do
				[[ -n ${record} ]] && ${RRDTOOL} update ${RRDDIR}/${PRG}.rrd  ${record}
			done
	else
		${RRDTOOL} update ${RRDDIR}/${PRG}.rrd ${TODAY}:${L1M}:${L5M}:${L15M}
	fi

	# overlay triggers if needed
	TRIGGERS=$(sed 's| |\n|g' <<< ${TO} | grep "${PRG}:" |  sed "s|${PRG}:\(trigger[0-9]\{1,2\}\)|\1|g")

	if [[ ! -z ${TRIGGERS} ]]; then
		j=0
		for i in ${TRIGGERS}; do
			[ -e ${TO_REM} ] && legend=$(grep "${i}:" ${TO_REM} | sed "s|${i}: ||")
			TO_DEF="${TO_DEF} DEF:${i}=$RRDDIR/triggers.rrd:${i}:AVERAGE"
			TO_TICK="${TO_TICK} TICK:${i}${COLOR[$((15-$j))]}:1:${legend}"
			j=$(($j+1))
		done
	fi

	$RRDTOOL graph ${OUTDIR}/${PRG}.png \
	--start -129600 \
	--vertical-label "load" \
	--title="system load $DATUM" \
	--imgformat PNG \
	--alt-y-grid \
	--units-exponent 1 \
	--upper-limit 10 \
	--rigid \
	--width $WIDTH \
	--height $HEIGHT \
	--font TITLE:12:${FONTSDIR}/micrb.ttf \
	--font UNIT:10:${FONTSDIR}/micr.ttf \
	--font LEGEND:8:${FONTSDIR}/DejaVuSansMono-Roman.ttf \
	--font-render-mode normal \
	--font-smoothing-threshold 4 \
	--slope-mode \
	--interlaced \
	$RRDOPTS \
	DEF:1m=$RRDDIR/${PRG}.rrd:load1m:AVERAGE \
	DEF:5m=$RRDDIR/${PRG}.rrd:load5m:AVERAGE \
	DEF:15m=$RRDDIR/${PRG}.rrd:load15m:AVERAGE \
	'CDEF:mp1=1m,100,/' \
	'CDEF:mp5=5m,100,/' \
	'CDEF:mp15=15m,100,/' \
	'COMMENT:                       minimum    maximum   average     last\n' \
	'AREA:mp1#e9644a:average  1 minute    ' \
	'GPRINT:mp1:MIN:%2.2lf    ' \
	'GPRINT:mp1:MAX:%2.2lf    ' \
	'GPRINT:mp1:AVERAGE:%2.2lf    ' \
	'GPRINT:mp1:LAST:%2.2lf' \
	'COMMENT:\n' \
	'LINE1:mp15#333333:average 15 minutes   ' \
	'GPRINT:mp15:MIN:%2.2lf    ' \
	'GPRINT:mp15:MAX:%2.2lf    ' \
	'GPRINT:mp15:AVERAGE:%2.2lf    ' \
	'GPRINT:mp15:LAST:%2.2lf' \
	'COMMENT:\n' \
	${TO_DEF} \
	${TO_TICK}

# 'LINE:mp1#ba361a:'\
# 'AREA:mp5#eb9c4895:average  5 minutes   ' \
# 'AREA:mp15#ebd64890:average 15 minutes   ' \


	$RRDTOOL graph ${OUTDIR}/${PRG}-mini.png \
	--start -86400 \
	--vertical-label "load" \
	--title="system load $DATUM" \
	--imgformat PNG \
	--alt-y-grid \
	--units-exponent 1 \
	--upper-limit 10 \
	--rigid \
	--width $MWIDTH \
	--height $MHEIGHT \
	--no-legend \
	--font TITLE:10:${FONTSDIR}/DejaVuSansMono-Roman.ttf \
	--font UNIT:8:${FONTSDIR}/DejaVuSansMono-Roman.ttf \
	--font-render-mode normal \
	--font-smoothing-threshold 6 \
	--slope-mode \
	--interlaced \
	$RRDOPTS \
	DEF:1m=$RRDDIR/${PRG}.rrd:load1m:AVERAGE \
	DEF:5m=$RRDDIR/${PRG}.rrd:load5m:AVERAGE \
	DEF:15m=$RRDDIR/${PRG}.rrd:load15m:AVERAGE \
	'CDEF:mp1=1m,100,/' \
	'CDEF:mp5=5m,100,/' \
	'CDEF:mp15=15m,100,/' \
	'AREA:mp1#e9644a:' \
	'LINE:mp15#333333:' \
	${TO_DEF} \
	${TO_TICK}

fi

