#!/bin/bash
# plugin that uses ipmitool to get system sensor data

CONF=${CONF:-'/etc/netzmon/netzmon.conf'}

[[ -e ${CONF} ]] && . ${CONF}

for ((i=0;i<${#IPMI_SENSOR[@]};i++)); do
    ALL_IPMI="${ALL_IPMI} \"${IPMI_SENSOR[${i}]}\""
    ALL_REP="${ALL_REP} ${IPMI_SENSOR[${i}]// /_}"
done

PRG="ipmi-sensor"
PRGVER="001"

# test if data has to be generated locally
if [[ -z ${DATASRC} ]]; then

	HISTORY="${DATUM} ${TODAY}"
	TXTREPORT="${PRG}:${PRGVER}:${ALL_REP// /:} ${TODAY}"
	RRDCMD_UPDATE="${RRDTOOL} update ${RRDDIR}/${PRG}.rrd ${TODAY}"
	IPMI_OUTPUT=$(eval /usr/sbin/ipmitool sensor get ${ALL_IPMI})
else

	# find out what SENSORS we have to generate
	REMOTE_SENSORS=`grep "^${PRG}:" ${DATASRC} | awk '{ print $1 }' | tail -n1 | sed "s|^${PRG}:${PRGVER}:||g"`
	SENSORS="${REMOTE_SENSORS//:/ }"

	count=0
	for i in $SENSORS; do
		IPMI_SENSOR[${count}]="$i"
		count=$(( ${count} + 1 ))
	done

fi

count=0

for ((i=0;i<${#IPMI_SENSOR[@]};i++)); do

	# test if data has to be generated locally
	if [[ -z ${DATASRC} ]]; then
		value=$(grep -A12 "${IPMI_SENSOR[$i]}" <<< "${IPMI_OUTPUT}" | grep -i 'Sensor Reading' | sed 's|.*: \([0-9]\{1,3\}\).*|\1|')
		HISTORY="$HISTORY:${value}"
		TXTREPORT="${TXTREPORT}:${value}"
		RRDCMD_UPDATE="${RRDCMD_UPDATE}:${value}"
	fi

	RRDCMD_LARGE="${RRDCMD_LARGE} \
		DEF:sensor${count}=$RRDDIR/${PRG}.rrd:sensor${count}:AVERAGE \
		LINE2:sensor${count}${COLOR[$(($count))]}:\"${IPMI_SENSOR[$i]//_/ }  \t\": \
		GPRINT:sensor${count}:MIN:\"%5.0lf    \"\
		GPRINT:sensor${count}:MAX:\"%5.0lf    \" \
		GPRINT:sensor${count}:AVERAGE:\"%5.0lf    \" \
		GPRINT:sensor${count}:LAST:\"%5.0lf\" \
		'COMMENT:\n' "

	RRDCMD_SMALL="${RRDCMD_SMALL} \
		DEF:sensor${count}=$RRDDIR/${PRG}.rrd:sensor${count}:AVERAGE \
		LINE2:sensor${count}${COLOR[$(($count))]}:: \
		'COMMENT:\n' "

	count=$((${count}+1))

done

if [[ -z ${DATASRC} ]]; then

	# rrdtool expects 16 values
	for ((i=${count};i<16;i++)); do
		TXTREPORT="${TXTREPORT}:0"
		RRDCMD_UPDATE="${RRDCMD_UPDATE}:0"
		HISTORY="${HISTORY}:0"
	done

	# Werte archivieren
	echo ${HISTORY} >> ${DATADIR}/${PRG}-history.${UDATE}

fi

if [[ ${OUTTYPE} == "txt" ]]; then

	echo "${TXTREPORT}" >> ${OUTDIR}/report.txt

elif [[ ${OUTTYPE} == "rrd" ]]; then

	[ -e ${RRDDIR}/${PRG}.rrd ] || ${BINDIR}/mkrrd.sh ${PRG}

	if [[ -n ${DATASRC} ]]; then
		grep "^${PRG}:" ${DATASRC} | awk '{ print $2 }'| \
			while read record; do
				[[ -n ${record} ]] && ${RRDTOOL} update ${RRDDIR}/${PRG}.rrd  ${record}
			done
	else
		eval ${RRDCMD_UPDATE}
	fi

	# overlay triggers if needed
	TRIGGERS=$(sed 's| |\n|g' <<< ${TO} | grep "${PRG}:" |  sed "s|${PRG}:\(trigger[0-9]\{1,2\}\)|\1|g")

	if [[ ! -z ${TRIGGERS} ]]; then
		j=0
		for i in ${TRIGGERS}; do
			[ -e ${TO_REM} ] && legend=$(grep "${i}:" ${TO_REM} | sed "s|${i}: ||")
			TO_DEF="${TO_DEF} DEF:${i}=$RRDDIR/triggers.rrd:${i}:AVERAGE"
			TO_TICK="${TO_TICK} TICK:${i}${COLOR[$((15-$j))]}:1:${legend}"
			j=$(($j+1))
		done
	fi

	RRDCMD="$RRDTOOL graph ${OUTDIR}/${PRG}.png \
	--start -129600 \
	--vertical-label 'values' \
	--title='ipmi data  $DATUM' \
	--imgformat PNG \
	--lower-limit 0 \
	--width $WIDTH \
	--height $HEIGHT \
	--font TITLE:12:${FONTSDIR}/micrb.ttf \
	--font UNIT:10:${FONTSDIR}/micr.ttf \
	--font LEGEND:8:${FONTSDIR}/DejaVuSansMono-Roman.ttf \
	--font-render-mode normal \
	--font-smoothing-threshold 4 \
	--slope-mode \
	--interlaced \
	$RRDOPTS \
	'COMMENT:ipmi sensor           minimum     maximum    average    last\n' \
	${RRDCMD_LARGE} \
	${TO_DEF} \
	${TO_TICK}
	"

	eval "${RRDCMD}"

	RRDCMD="$RRDTOOL graph ${OUTDIR}/${PRG}-mini.png \
	--start -86400 \
	--vertical-label 'values' \
	--title='ipmi data $DATUM' \
	--imgformat PNG \
	--lower-limit 0 \
	--width $MWIDTH \
	--height $MHEIGHT \
	--no-legend \
	--font TITLE:10:${FONTSDIR}/DejaVuSansMono-Roman.ttf \
	--font UNIT:8:${FONTSDIR}/DejaVuSansMono-Roman.ttf \
	--font-render-mode normal \
	--font-smoothing-threshold 6 \
	--slope-mode \
	--interlaced \
	${RRDCMD_SMALL} \
	${TO_DEF} \
	${TO_TICK}
	"

	eval "${RRDCMD}"

fi

