#!/bin/bash
# Werte fuer HTTP-Hits ermitteln und speichern

CONF=${CONF:-'/etc/netzmon/netzmon.conf'}

[[ -e ${CONF} ]] && . ${CONF}

PRG="httphits"
PRGVER="001"

# test if data has to be generated locally
if [[ -z ${DATASRC} ]]; then

	[[ ! -e ${APACHELOG} ]] && exit 1

	LAST=${TMPDIR}/${PRG}_last

	[[ -e ${LAST} ]] && LASTPARSED="`cat ${LAST}`" || LASTPARSED=1

	LASTLINE=`wc -l < ${APACHELOG}`
	
	[[ "${LASTLINE}" < "${LASTPARSED}" ]] && LASTPARSED=1

	for ((i=1;i<6;i++)); do
		status[$i]=$(sed -n "${LASTPARSED},${LASTLINE}p" < ${APACHELOG} | egrep "\"(GET|POST) [^\"]*\" $i[0-9][0-9] " | wc -l)
	done

	echo -n "$DATUM $TODAY:0:${status[1]}:${status[2]}:${status[3]}:${status[4]}:${status[5]}" >> $DATADIR/${PRG}-history.$UDATE

	echo "${LASTLINE}" > "${LAST}"

fi

if [[ ${OUTTYPE} == "txt" ]]; then

	echo "${PRG}:${PRGVER} ${TODAY}:0:${status[1]}:${status[2]}:${status[3]}:${status[4]}:${status[5]}" >> ${OUTDIR}/report.txt

elif [[ ${OUTTYPE} == "rrd" ]]; then

	[ -e ${RRDDIR}/${PRG}.rrd ] || ${BINDIR}/mkrrd.sh ${PRG}

	if [[ -n ${DATASRC} ]]; then
		grep "^${PRG}:${PRGVER} " ${DATASRC} | awk '{ print $2 }'| \
			while read record; do
				[[ -n ${record} ]] && ${RRDTOOL} update ${RRDDIR}/${PRG}.rrd  ${record}
			done
	else
		$RRDTOOL update $RRDDIR/${PRG}.rrd $TODAY:0:${status[1]}:${status[2]}:${status[3]}:${status[4]}:${status[5]}
	fi

	# overlay triggers if needed
	TRIGGERS=$(sed 's| |\n|g' <<< ${TO} | grep "${PRG}:" |  sed "s|${PRG}:\(trigger[0-9]\{1,2\}\)|\1|g")

	if [[ ! -z ${TRIGGERS} ]]; then
		j=0
		for i in ${TRIGGERS}; do
			[ -e ${TO_REM} ] && legend=$(grep "${i}:" ${TO_REM} | sed "s|${i}: ||")
			TO_DEF="${TO_DEF} DEF:${i}=$RRDDIR/triggers.rrd:${i}:AVERAGE"
			TO_TICK="${TO_TICK} TICK:${i}${COLOR[$((15-$j))]}:1:${legend}"
			j=$(($j+1))
		done
	fi

	$RRDTOOL graph ${OUTDIR}/${PRG}.png \
	--start -129600 \
	--vertical-label "hits/5m" \
	--title="http hits per 5 minutes  $DATUM" \
	--imgformat PNG \
	--width $WIDTH \
	--height $HEIGHT \
	--font TITLE:12:${FONTSDIR}/micrb.ttf \
	--font UNIT:10:${FONTSDIR}/micr.ttf \
	--font LEGEND:8:${FONTSDIR}/DejaVuSansMono-Roman.ttf \
	--font-render-mode normal \
	--font-smoothing-threshold 4 \
	--slope-mode \
	--interlaced \
	$RRDOPTS \
	DEF:hits100=$RRDDIR/${PRG}.rrd:hits100:AVERAGE \
	DEF:hits200=$RRDDIR/${PRG}.rrd:hits200:AVERAGE \
	DEF:hits300=$RRDDIR/${PRG}.rrd:hits300:AVERAGE \
	DEF:hits400=$RRDDIR/${PRG}.rrd:hits400:AVERAGE \
	DEF:hits500=$RRDDIR/${PRG}.rrd:hits500:AVERAGE \
	'COMMENT:                       minimum     maximum     average        last\n' \
	AREA:hits100#B22222:"http 100-199 status" \
	'GPRINT:hits100:MIN:%6.0lf    ' \
	'GPRINT:hits100:MAX:%6.0lf    ' \
	'GPRINT:hits100:AVERAGE:%6.0lf    ' \
	'GPRINT:hits100:LAST:%6.0lf' \
	'COMMENT:\n' \
	STACK:hits200#4682B4:"http 200-299 status" \
	'GPRINT:hits200:MIN:%6.0lf    ' \
	'GPRINT:hits200:MAX:%6.0lf    ' \
	'GPRINT:hits200:AVERAGE:%6.0lf    ' \
	'GPRINT:hits200:LAST:%6.0lf' \
	'COMMENT:\n' \
	STACK:hits300#228B22:"http 300-399 status" \
	'GPRINT:hits300:MIN:%6.0lf    ' \
	'GPRINT:hits300:MAX:%6.0lf    ' \
	'GPRINT:hits300:AVERAGE:%6.0lf    ' \
	'GPRINT:hits300:LAST:%6.0lf' \
	'COMMENT:\n' \
	STACK:hits400#FFA500:"http 400-499 status" \
	'GPRINT:hits400:MIN:%6.0lf    ' \
	'GPRINT:hits400:MAX:%6.0lf    ' \
	'GPRINT:hits400:AVERAGE:%6.0lf    ' \
	'GPRINT:hits400:LAST:%6.0lf' \
	'COMMENT:\n' \
	STACK:hits500#FF1493:"http 500-599 status" \
	'GPRINT:hits500:MIN:%6.0lf    ' \
	'GPRINT:hits500:MAX:%6.0lf    ' \
	'GPRINT:hits500:AVERAGE:%6.0lf    ' \
	'GPRINT:hits500:LAST:%6.0lf' \
	'COMMENT:\n' \
	${TO_DEF} \
	${TO_TICK}

	$RRDTOOL graph ${OUTDIR}/${PRG}-mini.png \
	--start -86400 \
	--vertical-label "hits" \
	--title="http hits  $DATUM" \
	--imgformat PNG \
	--width $MWIDTH \
	--height $MHEIGHT \
	--no-legend \
	--font TITLE:10:${FONTSDIR}/DejaVuSansMono-Roman.ttf \
	--font UNIT:8:${FONTSDIR}/DejaVuSansMono-Roman.ttf \
	--font-render-mode normal \
	--font-smoothing-threshold 6 \
	--slope-mode \
	--interlaced \
	$RRDOPTS \
	DEF:hits100=$RRDDIR/${PRG}.rrd:hits100:AVERAGE \
	DEF:hits200=$RRDDIR/${PRG}.rrd:hits200:AVERAGE \
	DEF:hits300=$RRDDIR/${PRG}.rrd:hits300:AVERAGE \
	DEF:hits400=$RRDDIR/${PRG}.rrd:hits400:AVERAGE \
	DEF:hits500=$RRDDIR/${PRG}.rrd:hits500:AVERAGE \
	'AREA:hits100#B22222:' \
	'STACK:hits200#4682B4:' \
	'STACK:hits300#228B22:' \
	'STACK:hits400#FFA500:' \
	'STACK:hits500#FF1493:' \
	${TO_DEF} \
	${TO_TICK}

fi

